<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\SubscriptionController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::post('/single-charge', [HomeController::class, 'singleCharge'])->name('single.charge');
Route::get('/plans/create', [SubscriptionController::class, 'showPlansForm'])->name('plans.create');
Route::post('/plans/store', [SubscriptionController::class, 'savePlan'])->name('plans.store');
Route::view('/plans', 'stripe.plans');
Route::get('/allplans', [SubscriptionController::class, 'allPlans'])->name('all.plans');
Route::get('/plans/checkout/{planId}', [SubscriptionController::class, 'plansCheckout'])->name('plans.checkout');
Route::post('/plans/process',[SubscriptionController::class,'planProcess'])->name('plan.process');
Route::get('/allsubscriptions', [SubscriptionController::class, 'allSubscription'])->name('all.subscription');