<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Pricing page</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.bundle.min.js">
    <style>
        body {
            background-color: #E0E0E0;
        }

        .card-pricing {
            z-index: 1;
            border: 1px solid #007bff;
        }

        .card-pricing .list-unstyled li {
            padding: .5rem 0;
            color: #6c757d;
            font-weight: 300;
        }

        .btn {
            border-radius: 1px;
            font-weight: 300;
        }

        .hvr:hover {

            color: #fff;
            background-color: #007bff;
            border: 1px solid #007bff !important;
        }
    </style>
</head>

<body>

    <div class="container mb-5 mt-5">
        <div class="pricing card-deck flex-column flex-md-row mb-3">
            <div class="card card-pricing text-center px-3 mb-4">
                <span class="h6 w-60 mx-auto px-4 py-1 rounded-bottom bg-primary text-white shadow-sm">Starter</span>
                <div class="bg-transparent card-header pt-4 border-0">
                    <h1 class="h1 font-weight-normal text-primary text-center mb-0" data-pricing-value="15">
                        &#x20b9;<span class="price">{{$starter->price}}</span><span class="h6 text-muted ml-2">/
                            month</span></h1>
                </div>
                <div class="card-body pt-0">
                    <ul class="list-unstyled mb-4">
                        <li>Up to 5 users</li>
                        <li>Basic support</li>
                        <li>Monthly updates</li>
                        <li>Free cancelation</li>
                    </ul>
                    <a href="{{route('plans.checkout',$starter->plan_id)}}" type="button"
                        class="btn btn-outline-secondary mb-3 hvr">Order now</a>
                </div>
            </div>
            <div class="card card-pricing popular shadow text-center px-3 mb-4">
                <span
                    class="h6 w-60 mx-auto px-4 py-1 rounded-bottom bg-primary text-white shadow-sm">Professional</span>
                <div class="bg-transparent card-header pt-4 border-0">
                    <h1 class="h1 font-weight-normal text-primary text-center mb-0" data-pricing-value="30">
                        &#x20b9;<span class="price">{{$professional->price}}</span><span class="h6 text-muted ml-2">/
                        month</span></h1>
                </div>
                <div class="card-body pt-0">
                    <ul class="list-unstyled mb-4">
                        <li>Up to 10 users</li>
                        <li>Email Support support</li>
                        <li>Monthly updates</li>
                        <li>Free cancelation</li>
                    </ul>
                    <a href="{{route('plans.checkout',$professional->plan_id)}}" class="btn btn-primary mb-3">Order
                        Now</a>
                </div>
            </div>
            <div class="card card-pricing text-center px-3 mb-4">
                <span class="h6 w-60 mx-auto px-4 py-1 rounded-bottom bg-primary text-white shadow-sm">Business</span>
                <div class="bg-transparent card-header pt-4 border-0">
                    <h1 class="h1 font-weight-normal text-primary text-center mb-0" data-pricing-value="45">
                        &#x20b9;<span class="price">{{$business->price}}</span><span class="h6 text-muted ml-2">/
                            month</span></h1>
                </div>
                <div class="card-body pt-0">
                    <ul class="list-unstyled mb-4">
                        <li>Up to 15 users</li>
                        <li>Email & phone support</li>
                        <li>Monthly updates</li>
                        <li>Free cancelation</li>
                    </ul>
                    <a href="{{route('plans.checkout',$business->plan_id)}}" type="button"
                        class="btn btn-outline-secondary mb-3 hvr">Order now</a>
                </div>
            </div>
            <div class="card card-pricing text-center px-3 mb-4">
                <span class="h6 w-60 mx-auto px-4 py-1 rounded-bottom bg-primary text-white shadow-sm">Enterprise</span>
                <div class="bg-transparent card-header pt-4 border-0">
                    <h1 class="h1 font-weight-normal text-primary text-center mb-0" data-pricing-value="60">
                        &#x20b9;<span class="price">{{$enterprise->price}}</span><span class="h6 text-muted ml-2">/
                            month</span></h1>
                </div>
                <div class="card-body pt-0">
                    <ul class="list-unstyled mb-4">
                        <li>Up to 20 users</li>
                        <li>Basic support</li>
                        <li>Monthly updates</li>
                        <li>Free cancelation</li>
                    </ul>
                    <a href="{{route('plans.checkout',$enterprise->plan_id)}}" type="button"
                        class="btn btn-outline-secondary mb-3 hvr">Order now</a>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js">

    </script>

</body>

</html>