<?php

namespace App\Http\Controllers;

use App\Models\Plan as ModelsPlan;
use Stripe\Plan;
use Stripe;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Laravel\Cashier\Subscription;

class SubscriptionController extends Controller
{
    public function showPlansForm()
    {
        return view('stripe.plans.create');
    }

    public function savePlan(Request $request)
    {

        Stripe\Stripe::setApiKey('sk_test_51IwKQfSHVh5v2cN1TR4sJ1CXxGpGc4Xc2mrgCiLFmk9ETKn04GlK2UqPrqTUczf3Np0OKFenKgfpCKONGInkiXPx002alZvb4Z');

        $amount = $request->amount;
        $amount = $amount * 100;
        $billing_period = $request->billing_period;
        $currency = $request->currency;

        try {

            $plan = Plan::create([
                'amount' => $amount,
                'currency' => $currency,
                'interval' => $billing_period,
                'interval_count' => $request->interval_count,
                'product' => [
                    'name' => $request->name
                ]
            ]);

            // dd($plan);

            $actual_amount = ($plan->amount) / 100;

            ModelsPlan::insert([
                'plan_id' => $plan->id,
                'name' => $request->name,
                'billing_method' => $plan->interval,
                'interval_count' => $request->interval_count,
                'price' => $actual_amount,
                'currency' => $plan->currency
            ]);
        } catch (Exception $ex) {
            dd($ex->getMessage());
        }
        return "New Plan created successfully";
    }

    public function allPlans()
    {
        $starter = ModelsPlan::where('name', 'starter')->first();
        $professional = ModelsPlan::where('name', 'professional')->first();
        $business = ModelsPlan::where('name', 'business')->first();
        $enterprise = ModelsPlan::where('name', 'enterprise')->first();

        return view('stripe.plans', compact('starter', 'professional', 'business', 'enterprise'));
    }

    public function plansCheckout($planId)
    {
        $plan = ModelsPlan::where('plan_id', $planId)->first();
        if (!$plan) {
            return back()->withErrors([
                'message' => 'Unable to locate the plan'
            ]);
        }
        // dd($plan);
        return view('stripe.plans.checkout', [
            'plan' => $plan,
            'intent' => Auth::user()->createSetupIntent()
        ]);
    }


    public function planProcess(Request $request){

        $user = Auth::user();
        $user->createOrGetStripeCustomer();
        $paymentMethod = null;
        $paymentMethod = $request->payment_method;
        if ($paymentMethod != null) {
            $paymentMethod = $user->addPaymentMethod($paymentMethod);
        }

        $plan_id = $request->plan_id;
        $plan_price = $request->price;

        try {
            $user->newSubscription(
                'Default',
                $plan_id
            )->create($paymentMethod != null ? $paymentMethod->id : '');
        } catch (Exception $ex) {

            return back()->withErrors([
                'error' => $ex->getMessage()
            ]);
        }

        $request->session()->flash('alert-success', 'You are subscribed to this plan');

        return redirect()->route('plans.checkout', $plan_id);

    }

    public function allSubscription(){

        // $subscriptions = Auth::user()->subscriptions;
        $subscriptions = Subscription::where('user_id', Auth::id())->get();
        dd($subscriptions);

    }


}