<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $user = Auth::user();
        return view('home',[
            'intent' => $user->createSetupIntent(),
        ]);
    }

    public function singleCharge(Request $request){

        // dd($request);

        $amount = $request->amount;
        $amount = $amount * 100;
        $paymentMethod = $request->payment_method;

        // dd($amount);

        // dd($paymentMethod);

        $user = Auth::user();
        $user->createOrGetStripeCustomer();

        $paymentMethod = $user->addPaymentMethod($paymentMethod);

        $user->charge($amount,$paymentMethod->id);

        return redirect()->back();

        // dd($request->all());

        // return response()->json([
        //     'status' => 200,
        //     'amount' => $amount,
        //     'payment_method' => $paymentMethod
        // ]);

    }

}
